<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->index('provider', 'vfinance_provider');
            $table->index('finance_type', 'vfinance_type');
            $table->index('monthly_price', 'vfinance_price');
        });
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->index('slug', 'vav_slug');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->dropIndex('vfinance_provider');
            $table->dropIndex('vfinance_type');
            $table->dropIndex('vfinance_price');
        });
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->dropIndex('vav_slug');
        });
    }
};
