<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->integer('battery_quick_charge_level')->index()->nullable();
        });
        Schema::table('vehicles', function (Blueprint $table) {
            $table->integer('battery_quick_charge_level')->index()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('battery_quick_charge_level');
        });

        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn('battery_quick_charge_level');
        });
    }
};
