<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('dealerships', function (Blueprint $table) {
            $table->foreignId('template_id')->nullable()->index();
        });

        Schema::create('dealership_content', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dealership_id')->index();
            $table->foreignId('parent_id')->nullable()->index();
            $table->foreignId('template_element_id')->nullable()->index();
            $table->foreignId('global_content_id')->nullable()->index();
            $table->foreignId('element_id')->nullable()->index();
            $table->string('name')->nullable();
            $table->mediumText('content')->nullable();
            $table->text('search_content')->nullable();
            $table->mediumText('data')->nullable();
            $table->unsignedInteger('order')->default(0)->index();
            $table->string('slug')->nullable()->index();
            $table->boolean('hidden')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('dealership_content_history', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->index();
            $table->foreignId('dealership_id')->index();
            $table->foreignId('author_id')->nullable()->index();
            $table->boolean('is_active')->index();
            $table->mediumText('data')->nullable();
            $table->timestamps();
            $table->boolean('pending_review')->nullable()->index();
            $table->boolean('request_changes')->nullable()->index();
            $table->softDeletes()->index();
            $table->index('created_at');
            $table->index('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('dealerships', function (Blueprint $table) {
            $table->dropColumn('template_id');
        });

        Schema::dropIfExists('dealership_content');

        Schema::dropIfExists('dealership_content_history');
    }
};
