<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->string('new_car_type')->index()->nullable();
            $table->string('trim')->index()->nullable();
            $table->decimal('mpg', 8, 2)->nullable();
            $table->text('key_features')->nullable();
            $table->text('description')->nullable();
            $table->text('standard_spec')->nullable();
            $table->text('technical_spec')->nullable();
            $table->string('youtube_video')->nullable();
            $table->text('t_and_cs')->nullable();
        });

        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->integer('annual_mileage')->nullable();
            $table->decimal('customer_deposit', 8, 2)->nullable();
            $table->decimal('dealer_deposit_contribution', 8, 2)->nullable();
            $table->decimal('option_to_purchase_fee', 8, 2)->nullable();
            $table->decimal('excess_mileage_charge', 8, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('new_car_type');
            $table->dropColumn('trim');
            $table->dropColumn('mpg');
            $table->dropColumn('key_features');
            $table->dropColumn('description');
            $table->dropColumn('standard_spec');
            $table->dropColumn('technical_spec');
            $table->dropColumn('youtube_video');
            $table->dropColumn('t_and_cs');
        });

        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->dropColumn('annual_mileage');
            $table->dropColumn('customer_deposit');
            $table->dropColumn('dealer_deposit_contribution');
            $table->dropColumn('option_to_purchase_fee');
            $table->dropColumn('excess_mileage_charge');
        });
    }
};
