<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('filter_index', function (Blueprint $table) {

            $table->dropIndex('filter_index_slug_unique');
            $table->index('slug', 'filter_index_slug');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('filter_index', function (Blueprint $table) {
            $table->dropIndex('filter_index_slug');
            $table->unique('slug', 'filter_index_slug_unique');
        });
    }
};
