<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->decimal('monthly_price', 12)->nullable()->change();
            $table->decimal('first_payment', 12)->nullable()->change();
            $table->decimal('final_payment', 12)->nullable()->change();
            $table->decimal('customer_deposit', 12)->nullable()->change();
            $table->decimal('dealer_deposit', 12)->nullable()->change();
            $table->decimal('total_deposit', 12)->nullable()->change();
            $table->decimal('total_credit_amount', 12)->nullable()->change();
            $table->decimal('payable_amount', 12)->nullable()->change();
            $table->decimal('cash_price', 12)->nullable()->change();
            $table->decimal('option_to_purchase_fee', 12)->nullable()->change();
            $table->decimal('documentation_fee', 12)->nullable()->change();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_finance', function (Blueprint $table) {
            //
        });
    }
};
