<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('media', function (Blueprint $table) {
            $table->index('created_at', 'media_created_at');
            $table->index('updated_at', 'media_updated_at');
        });

        Schema::table('media_uses', function (Blueprint $table) {
            $table->index('created_at', 'media_uses_created_at');
            $table->index('updated_at', 'media_uses_updated_at');
            $table->index('order', 'media_uses_order');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('media', function (Blueprint $table) {
            $table->dropIndex('media_created_at');
            $table->dropIndex('media_updated_at');
        });

        Schema::table('media_uses', function (Blueprint $table) {
            $table->dropIndex('media_uses_created_at');
            $table->dropIndex('media_uses_updated_at');
        });
    }
};
