<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!app()->runningUnitTests()) {

            // delete any duplicate records which would stop the index creation

            DB::statement(
                'DELETE vf1 FROM vehicle_features vf1
                    INNER JOIN vehicle_features vf2
                    WHERE vf1.id < vf2.id
                    AND vf1.vehicle_id = vf2.vehicle_id
                    AND vf1.name = vf2.name
                    AND vf1.vehicle_type = vf2.vehicle_type'
            );

            DB::statement(
                'DELETE vf1 FROM vehicle_standard_equipment vf1
                    INNER JOIN vehicle_standard_equipment vf2
                    WHERE vf1.id < vf2.id
                    AND vf1.vehicle_id = vf2.vehicle_id
                    AND vf1.description = vf2.description
                    AND vf1.vehicle_type = vf2.vehicle_type'
            );

            DB::statement(
                'DELETE vf1 FROM vehicle_tech_data vf1
                    INNER JOIN vehicle_tech_data vf2
                    WHERE vf1.id < vf2.id
                    AND vf1.vehicle_id = vf2.vehicle_id
                    AND vf1.description = vf2.description
                    AND vf1.vehicle_type = vf2.vehicle_type'
            );
        }

        Schema::table('vehicle_features', function (Blueprint $table) {
            $table->unique(['vehicle_id', 'vehicle_type', 'name'], 'vehicle_features_unique_id_name');
        });

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->unique(['vehicle_id', 'vehicle_type', 'description'], 'vehicle_standard_equipment_unique_id_description');
        });

        Schema::table('vehicle_tech_data', function (Blueprint $table) {
            $table->unique(['vehicle_id', 'vehicle_type', 'description'], 'vehicle_tech_data_unique_id_description');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_features', function (Blueprint $table) {
            $table->dropUnique('vehicle_features_unique_id_name');
        });

        Schema::table('vehicle_standard_equipment', function (Blueprint $table) {
            $table->dropUnique('vehicle_standard_equipment_unique_id_description');
        });

        Schema::table('vehicle_tech_data', function (Blueprint $table) {
            $table->dropUnique('vehicle_tech_data_unique_id_description');
        });
    }
};
