<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->string('wheelbase_type')->nullable();
            $table->integer('wheelbase_mm')->nullable();
            $table->integer('payload_kg')->nullable();
            $table->decimal('gross_vehicle_weight_kg', 8, 2)->nullable();
            $table->decimal('bhp', 8, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn('wheelbase_type');
            $table->dropColumn('wheelbase_mm');
            $table->dropColumn('payload_kg');
            $table->dropColumn('gross_vehicle_weight_kg');
            $table->dropColumn('bhp');
        });
    }
};
