<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('valuation_adjustments', function (Blueprint $table) {
            $table->id();
            $table->boolean('is_active')->nullable()->index();
            $table->boolean('is_increase')->nullable()->index();
            $table->integer('adjustment_amount')->nullable();
            $table->string('adjustment_type', 20)->nullable();
            $table->timestamps();
        });

        Schema::create('valuation_adjustment_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('adjustment_id')->index();
            $table->string('column', 100)->index();
            $table->string('operator');
            $table->string('value')->index();
            $table->timestamps();
        });

        Schema::table('valuations', function (Blueprint $table) {
            $table->foreignId('adjustment_id')->nullable()->index();
            $table->decimal('adjusted_value')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('valuation_adjustments');
        Schema::dropIfExists('valuation_adjustment_rules');

        Schema::table('valuations', function (Blueprint $table) {
            $table->dropColumn([
                'adjustment_id',
                'adjusted_value',
            ]);
        });
    }
};
