<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class NullableVehicleFinance extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->smallInteger('term')->comment('term length in months')->nullable()->change();
            $table->smallInteger('number_of_payments')->comment('number of monthly payments')->nullable()->change();
            $table->decimal('monthly_price')->nullable()->change();
            $table->decimal('first_payment')->nullable()->change();
            $table->decimal('final_payment')->nullable()->change();
            $table->decimal('deposit')->nullable()->change();
            $table->decimal('interest_rate')->nullable()->change();
            $table->decimal('apr')->nullable()->change();
            $table->string('apply_url')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
