<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('vehicle_attributes') === false) {
            Schema::create('vehicle_attributes', function (Blueprint $table) {
                $table->id();
                $table->string('name')->index();
                $table->string('slug')->index();
                $table->string('type')->index();
                $table->text('validation')->nullable();
                $table->unsignedSmallInteger('count')->default(1);
                $table->text('data')->nullable();
                $table->unsignedInteger('order')->default(0)->index();
                $table->timestamps();
            });
        }

        if (Schema::hasTable('vehicle_attribute_values') === false) {
            Schema::create('vehicle_attribute_values', function (Blueprint $table) {
                $table->id();
                $table->foreignId('vehicle_id')->index();
                $table->foreignId('attribute_id')->index();
                $table->string('slug')->nullable();
                $table->string('type')->nullable();
                $table->string('value')->nullable()->index();
                $table->integer('value_float')->nullable()->index();
                $table->dateTime('value_datetime')->nullable()->index();
                $table->text('value_text')->nullable();
                $table->unsignedInteger('order')->default(0)->index();
                $table->unsignedInteger('index')->default(0)->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicle_attributes');
        Schema::dropIfExists('vehicle_attribute_values');
    }
};
