<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('page_versions', function (Blueprint $table) {
            $table->dropColumn('content');
        });

        Schema::table('vehicle_offer_content_history', function (Blueprint $table) {
            $table->dropColumn('content');
        });

        Schema::create('version_content', function (Blueprint $table) {
            $table->id();
            $table->morphs('owner');
            $table->foreignId('parent_id')->nullable()->index();
            $table->foreignId('template_element_id')->nullable()->index();
            $table->foreignId('global_content_id')->nullable()->index();
            $table->foreignId('element_id')->nullable()->index();
            $table->string('name')->nullable();
            $table->string('slug')->nullable();
            $table->mediumText('content')->nullable();
            $table->mediumText('data')->nullable();
            $table->unsignedInteger('order')->default(0)->index();
            $table->timestamps();
            $table->index('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('version_content');

        Schema::table('page_versions', function (Blueprint $table) {
            $table->mediumText('content')->nullable();
        });

        Schema::table('vehicle_offer_content_history', function (Blueprint $table) {
            $table->mediumText('content')->nullable();
        });

    }
};
