<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('page_versions', function (Blueprint $table) {
            $table->boolean('pending_review')->nullable()->index();
            $table->boolean('request_changes')->nullable()->index();
        });

        Schema::table('vehicle_offer_content_history', function (Blueprint $table) {
            $table->boolean('pending_review')->nullable()->index();
            $table->boolean('request_changes')->nullable()->index();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('page_versions', function (Blueprint $table) {
            $table->dropColumn([
                'pending_review',
                'request_changes',
            ]);
        });
        Schema::table('vehicle_offer_content_history', function (Blueprint $table) {
            $table->dropColumn([
                'pending_review',
                'request_changes',
            ]);
        });
    }
};
