<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_autotrader_data', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->index();
            $table->unsignedBigInteger('valuation')->nullable();
            $table->string('price_point')->nullable();
            $table->smallInteger('price_position')->nullable();
            $table->unsignedBigInteger('search_results_7d')->nullable();
            $table->unsignedBigInteger('ad_views')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_autotrader_data');
    }
};
