<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_views', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->index();
            $table->date('date')->index();
            $table->unsignedInteger('hits')->default(0);
            $table->unsignedInteger('filter_views')->default(0);
            $table->timestamps();
            $table->unique(['vehicle_id', 'date']);
        });

        Schema::create('offer_views', function (Blueprint $table) {
            $table->id();
            $table->foreignId('offer_id')->index();
            $table->date('date')->index();
            $table->unsignedInteger('hits')->default(0);
            $table->unsignedInteger('filter_views')->default(0);
            $table->timestamps();
            $table->unique(['offer_id', 'date']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_views');
        Schema::dropIfExists('offer_views');
    }
};
