<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->unsignedInteger('battery_range')->nullable();
            $table->unsignedInteger('battery_capacity_kwh')->nullable();
            $table->unsignedInteger('battery_usable_capacity_kwh')->nullable();
            $table->unsignedInteger('battery_charge_time')->nullable();
            $table->unsignedInteger('battery_quick_charge_time')->nullable();
        });

        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->unsignedInteger('battery_range')->nullable();
            $table->unsignedInteger('battery_capacity_kwh')->nullable();
            $table->unsignedInteger('battery_usable_capacity_kwh')->nullable();
            $table->unsignedInteger('battery_charge_time')->nullable();
            $table->unsignedInteger('battery_quick_charge_time')->nullable();
        });

        Schema::table('fuel_types', function (Blueprint $table) {
            $table->boolean('ev_data')->nullable();
            $table->boolean('mpg_data')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn([
                'battery_range',
                'battery_capacity_kwh',
                'battery_usable_capacity_kwh',
                'battery_charge_time',
                'battery_quick_charge_time',
            ]);
        });

        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn([
                'battery_range',
                'battery_capacity_kwh',
                'battery_usable_capacity_kwh',
                'battery_charge_time',
                'battery_quick_charge_time',
            ]);
        });

        Schema::table('fuel_types', function (Blueprint $table) {
            $table->dropColumn([
                'ev_data',
                'mpg_data',
            ]);
        });
    }
};
