<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->string('export_time', 6)->nullable();
            $table->smallInteger('export_day_of_week')->nullable();
            $table->smallInteger('export_day_of_month')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->dropColumns([
                'export_time',
                'export_day_of_week',
                'export_day_of_month',
            ]);
        });
    }
};
