<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->boolean('is_published')->default(0)->index()->after('published_at');
            $table->boolean('is_reserved')->default(0)->index()->after('is_published');
            $table->boolean('is_sold')->default(0)->index()->after('is_reserved');
            $table->boolean('is_demo')->default(0)->index()->after('is_new');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumns([
                'is_published',
                'is_sold',
                'is_demo',
                'is_reserved',
            ]);
        });
    }
};
