<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTenantVehicleTaxonomyTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('body_styles', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('autotrader_id')->index()->nullable();
            $table->timestamps();
        });
        Schema::create('drivetrains', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('autotrader_id')->index()->nullable();
            $table->timestamps();
        });
        Schema::create('fuel_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('autotrader_id')->index()->nullable();
            $table->timestamps();
        });
        Schema::create('transmissions', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('autotrader_id')->index()->nullable();
            $table->timestamps();
        });
        Schema::create('vehicle_makes', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('autotrader_id')->index()->nullable();
            $table->string('logo')->nullable();
            $table->string('monochrome_logo')->nullable();
            $table->timestamps();
        });
        Schema::create('vehicle_models', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('make_id');
            $table->string('name');
            $table->string('autotrader_id')->index()->nullable();
            $table->string('cap_id')->index()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('body_styles');
        Schema::dropIfExists('drivetrains');
        Schema::dropIfExists('fuel_types');
        Schema::dropIfExists('transmissions');
        Schema::dropIfExists('vehicle_makes');
        Schema::dropIfExists('vehicle_models');
    }
}
