<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Drop old views tables after migration to resource_views
        // Note: Run php artisan tenants:run views:migrate-to-resource-views first
        Schema::dropIfExists('vehicle_views');
        Schema::dropIfExists('offer_views');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Recreate vehicle_views table
        Schema::create('vehicle_views', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('vehicle_id')->index();
            $table->date('date')->index();
            $table->unsignedInteger('hits')->default(0);
            $table->unsignedInteger('quick_view_hits')->nullable();
            $table->unsignedInteger('filter_views')->nullable();
            $table->unsignedInteger('compare_views')->nullable();
            $table->unsignedInteger('compare_email_requests')->nullable();
            $table->timestamps();

            $table->unique(['vehicle_id', 'date']);
        });

        // Recreate offer_views table
        Schema::create('offer_views', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('offer_id')->index();
            $table->date('date')->index();
            $table->unsignedInteger('hits')->default(0);
            $table->unsignedInteger('filter_views')->nullable();
            $table->timestamps();

            $table->unique(['offer_id', 'date']);
        });
    }
};
