<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tenant_daily_metrics', function (Blueprint $table) {
            $table->id();
            $table->string('tenant_id');
            $table->date('date')->index();
            $table->unsignedInteger('enquiries_count')->default(0);
            $table->unsignedInteger('service_bookings_count')->default(0);
            $table->unsignedInteger('reservations_count')->default(0);
            $table->unsignedInteger('valuations_count')->default(0);

            $table->unsignedInteger('vehicles_added')->default(0);
            $table->unsignedInteger('vehicles_exited')->default(0);
            $table->unsignedInteger('visitors')->default(0);
            $table->decimal('enquiry_conversion_rate', 5, 2)->nullable();
            $table->decimal('booking_conversion_rate', 5, 2)->nullable();
            $table->decimal('reservation_conversion_rate', 5, 2)->nullable();
            $table->decimal('revenue', 12, 2)->default(0);
            $table->timestamps();

            $table->foreign('tenant_id')
                ->references('id')
                ->on('tenants')
                ->cascadeOnDelete();

            $table->unique(['tenant_id', 'date']);
            $table->index(['date', 'tenant_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tenant_daily_metrics');
    }
};
