<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_usage', function (Blueprint $table) {
            $table->unsignedInteger('slow_3s')->nullable()->default(0)->after('max');
            $table->unsignedInteger('slow_10s')->nullable()->default(0)->after('slow_3s');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_usage', function (Blueprint $table) {
            $table->dropColumn(['slow_3s', 'slow_10s']);
        });
    }
};
