<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('external_service_usage', function (Blueprint $table) {
            $table->id();
            $table->string('tenant_id');
            $table->string('service');
            $table->string('section');
            $table->integer('hits')->default(0);
            $table->timestamps();

            $table->unique(['tenant_id', 'service', 'section', 'created_at'], 'ext_serv_usage_unique');
            $table->index(['tenant_id', 'service', 'section']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('external_service_usage');
    }
};
