<?php

use App\Console\Commands\SeedGlobalData;
use App\Master\Models\Seed as GlobalSeed;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('seeds') === false) {
            Schema::create('seeds', function (Blueprint $table) {
                $table->id();
                $table->string('seeder')->index();
                $table->unsignedInteger('batch')->nullable();
                $table->timestamps();
            });
        }

        if(class_exists(SeedGlobalData::class)){
            $seeders = (new SeedGlobalData())->getSeeders();
            foreach ($seeders as $seeder) {
                GlobalSeed::query()
                    ->create([
                        'seeder' => $seeder,
                        'batch' => 1
                    ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('seeds');
    }
};
