<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('model_has_roles', function (Blueprint $table) {
            if (!app()->runningUnitTests()) {
                $table->dropForeign('model_has_roles_role_id_foreign');
            }

            $table->dropPrimary('model_has_roles_role_model_type_primary');

            DB::table('model_has_roles')->whereNull('tenant_id')->update(['tenant_id' => '']);

            $table->string('tenant_id')->default('')->change();

            $table->primary(['role_id', 'model_type', 'model_id', 'tenant_id'],
                'model_has_roles_role_model_type_primary');

            $table->foreign('role_id')->references('id')->on('roles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('model_has_roles', function (Blueprint $table) {
            //
        });
    }
};
