<?php

namespace Mtc\Members;

/**
 * Class Role
 *
 * Member user Role model
 * Adds global scope that narrows roles down to member user only
 */
class Role extends \Spatie\Permission\Models\Role
{
    /**
     * Name of the role group for admin users
     */
    public const GROUP_NAME = 'member';

    /**
     * Extend model booting
     */
    protected static function boot()
    {
        parent::boot();

        self::addGlobalScope(function ($query) {
            return $query->where('group', self::GROUP_NAME);
        });

        self::creating(function ($role) {
            $role->group = self::GROUP_NAME;
            $role->guard_name = self::GROUP_NAME;
        });
    }
}
