<?php

namespace Mtc\Members;

/**
 * Class Permission
 *
 * Member user Permission model
 * Adds global scope that narrows roles down to members only
 *
 * @package Mtc\Core\Admin
 */
class Permission extends \Spatie\Permission\Models\Permission
{
    /**
     * Name of the role group for admin users
     */
    public const GROUP_NAME = 'member';

    /**
     * Extend model booting
     */
    protected static function boot()
    {
        parent::boot();

        self::addGlobalScope(function ($query) {
            return $query->where('model_group', self::GROUP_NAME);
        });

        self::creating(function ($role) {
            $role->model_group = self::GROUP_NAME;
        });
    }
}
