<?php

namespace Mtc\Members\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Mtc\Foundation\Rules\ValidPhoneNumber;
use Mtc\Members\Facades\MemberAuth;

/**
 * Class UpdateDetailsRequest
 *
 * @package Mtc\Members\Http\Requests
 */
class UpdateDetailsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return MemberAuth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $exclude_id = MemberAuth::id();
        return collect([
            'name' => 'required',
            'email' => 'required|email|unique:members,email,' . $exclude_id,
        ])
            ->when($this->filled('contact_no'), function (Collection $rules) {
                return $rules->put('contact_no', [
                    new ValidPhoneNumber()
                ]);
            })
            ->when($this->filled('reset_password'), function (Collection $rules) {
                $password_strength = App::make(config('members.password_strength'));
                return $rules->put('password', [
                    'confirmed',
                    $password_strength
                ]);
            })
            ->toArray();
    }
}
