<?php

namespace Mtc\Members\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Members\Role;
use Mtc\Core\Admin\Menu;

/**
 * Class MemberInstallSeed
 *
 * @package Mtc\Members\Seeds
 */
class MemberInstallSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->seedMenu();
        $this->seedRoles();
    }

    /**
     * Seed user Roles
     */
    public function seedRoles()
    {
        Role::query()
            ->create([
                'name' => config('members.default_role'),
                'guard_name' => 'member',
                'group' => Role::GROUP_NAME,
            ]);

        Role::query()
            ->create([
                'name' => 'Trade Member',
                'guard_name' => 'member',
                'group' => Role::GROUP_NAME,
            ]);

    }

    /**
     * Seed Admin menu
     */
    public function seedMenu()
    {
        collect($this->getMenu())
            ->each(function ($menu_entry) {
                $children = $menu_entry['children'] ?? [];
                unset($menu_entry['children']);
                $menu = Menu::query()->create($menu_entry);

                foreach ($children as $sub_menu) {
                    $roles = $sub_menu['roles'] ?? [];
                    unset($sub_menu['roles']);
                    $child = $menu->children()->create($sub_menu);
                    Menu::grantMenuPermissionToRole($child, $roles);
                }
            });
    }

    /**
     * Get Data for Admin Menu entries
     *
     * @return array
     */
    protected function getMenu()
    {
        return [
            [
                'title' => 'Members',
                'path' => '',
                'activePath' => '',
                "icon" => "fa fa-users",
                'order' => 4,
                'children' => [
                    [
                        "title" => "Manage Members",
                        "path" => "/admin/members",
                        "activePath" => "/admin/members",
                        'icon' => '',
                        'roles' => [
                            'Administrator'
                        ],
                    ],
                ]
            ],
        ];
    }
}
