<?php

namespace Mtc\Members\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Mtc\Foundation\Rules\ValidPhoneNumber;
use Mtc\Members\Contracts\MemberModel;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\MemberAddress;

/**
 * Class UpdateDetailsRequest
 * 
 * @package Mtc\Members\Http\Requests
 */
class MemberAddressRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if ($this->address()->exists) {
            return MemberAuth::check() && MemberAuth::id() == $this->address()->member_id;
        }

        return MemberAuth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

    /**
     * Get member for request
     *
     * @return mixed|MemberModel
     */
    public function address()
    {
        if ($this->address instanceof MemberAddress) {
            return $this->address;
        }

        $address_id = !empty($this->address) ? base64_decode($this->address) : 0;
        return $this->address = MemberAddress::query()->findOrNew($address_id);
    }
}
