# Member accounts

This package provides ecommerce customer registration and members area workflow.
It is used by [shop system](https://bitbucket.org/mtcmedia/shop/) and provides customer accounts.

# Installation

This package is part of `mtcmedia/shop` package and therefore will automatically install this functionality. 
If you need to add it on a site that doesn't have it auto-installed run the following command

```shell
composer require mtcmedia/members
```

After composer has installed the component installer needs to be run:  
```shell
php artisan install:components
```

# Configuration
`config/members.php` provides a number of configuration options:

* `password_strength` - mechanism to define how strong passwords should be
* `member_roles` - whether customer accounts can have multiple roles (e.g. Retail/Trade customers)
* navigation elements (`navigation_links_start` and `navigation_links_end`) define structure of the members area
* controllers used by routes
* `admin_search_filters` allow specifying what can be used for filtering accounts in admin area

# Usage

This section providers a site section under `/members` path for customers. This includes both registration and login.

## Customer Journey

By default, customers get access to:

* Registration page
* Login page
* Members Dashboard
* Manage details (email/name management)
* Address book (add/update addresses)

Address book allows storing a number of addresses, selecting default one and using them as needed in sites (e.g. checkout).

## Authentication mechanism

Authentication uses Laravel patterns but instead of using `Auth` facade `Mtc\Members\Facades\MemberAuth` should be used.
Both `Auth` and `MemberAuth` use Laravel mechanisms for encrypting/storing/authenticating users but these facades use different
guards, therefore allowing customer and admin user accounts to be stored in different tables and interact differently
(log in as admin / log in as member).

For web routes there are two key middlewares in system:

* `Mtc\Members\Http\Middleware\LoggedInMember` allows route to be accessed only by logged in member, otherwise redirect to login page
* `Mtc\Members\Http\Middleware\NotAMember` allows route to be accessed only when not logged in, otherwise redirect to members dashboard

## Access Control

Same as with admin user setup in mtc system, members use `spatie/laravel-permission` to implement ACL mechanism.
Members have roles and permissions allowing restricting access to customers based on their role.

`members.member_roles` config is false by default, so roles are not active without configuration change

## Account management

`/admin/members` path exists for managing customer accounts. This allows admin users to view list of accounts and modify them easily.

## Ecommerce integration

Customer account module is primarily used with ecommerce sites. The module is standalone by itself, 
functionality like members past orders and basket population of customer account details is provided 
by a shop bridge package [mtcmedia/members-basket](https://bitbucket.org/mtcmedia/members-basket/).


