<?php

namespace Mtc\Members\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\HasMembersNavigation;
use Mtc\Members\Http\Requests\UpdateDetailsRequest;
use Mtc\Members\Member;

/**
 * Class DetailController
 *
 * @package Mtc\Members\Http\Controllers
 */
class DetailController extends Controller
{
    use HasMembersNavigation;

    /**
     * Show details
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show()
    {
        $this->page_meta['title'] = 'My Details | ' . config('app.name');
        $this->page_meta['page_title'] = 'Edit Details';

        return template('members/details.twig', [
            'page_meta' => $this->page_meta,
            'member' => MemberAuth::user(),
            'sections' => $this->sections(),
        ]);
    }

    /**
     * Update details
     *
     * @param UpdateDetailsRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(UpdateDetailsRequest $request)
    {
        /** @var Member $member */
        $member = MemberAuth::user();
        $member->fill([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'contact_no' => $request->input('contact_no'),
        ]);
        if ($request->input('change_password')) {
            $member->password = Hash::make($request->input('password'));
        }
        $member->save();

        return back()->with('success', 'Details Updated');
    }
}
