<?php

namespace Mtc\Members\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Members\Member;

/**
 * Class PopulateMembers
 *
 * @package Mtc\Members\Console\Commands
 */
class PopulateMembers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'populate:members {count=50}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Populate dummy member records';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        factory(Member::class, (int)$this->argument('count'))->create();
    }
}
