<?php

namespace Mtc\Members\Rules;

use Illuminate\Contracts\Validation\Rule;

/**
 * Class MediumStrengthPassword
 *
 * @package Mtc\Members
 */
class MediumStrengthPassword implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return (mb_strlen($value) > 7 // at least 8 chars
            && preg_match('/[0-9]/', $value) // at least number
            && preg_match('/[a-z]/i', $value)// at least one letter
        );
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The password must be at least 8 characters and must contain both letters and numbers.';
    }
}
