<?php

use Mtc\Members\Http\Controllers\Admin\MemberAddressController;
use Mtc\Members\Http\Middleware\LoggedInMember;
use Mtc\Members\Http\Middleware\NotAMember;
use Mtc\Members\Http\Controllers\DashboardController;
use Mtc\Members\Http\Controllers\AddressController;
use Mtc\Members\Http\Controllers\DetailController;
use Mtc\Members\Http\Controllers\Admin\MemberController;
use Mtc\Members\Http\Controllers\Auth\LoginController;
use Mtc\Members\Http\Controllers\Auth\ForgotPasswordController;
use Mtc\Members\Http\Controllers\Auth\ResetPasswordController;
use Mtc\Members\Http\Controllers\Auth\RegisterController;
use Mtc\Members\Http\Controllers\Admin\RoleController;


use Illuminate\Routing\Router;
/** @var Router $router */

$router->group([
    'prefix' => '/members/',
    'as' => 'members.',
], function (Router $router) {

    $router->group([
        'middleware' => [
            NotAMember::class
        ]
    ], function (Router $router) {
        $router->get('login', [LoginController::class, 'showLoginForm'])->name('login');
        $router->post('login', [LoginController::class, 'login'])->name('do-login');
        $router->get('register', [RegisterController::class, 'showRegistrationForm'])->name('register');
        $router->post('register', [RegisterController::class, 'register'])->name('do-register');
        $router->get('forgot-password', [ForgotPasswordController::class, 'show'])->name('password.request');
        $router->post('forgot-password', [ForgotPasswordController::class, 'send'])->name('password.send_reset');
        $router->get('reset-password', [ResetPasswordController::class, 'show'])->name('password.show_reset');
        $router->post('reset-password', [ResetPasswordController::class, 'reset'])->name('password.reset');
    });

    $router->group([
        'middleware' => [
            LoggedInMember::class
        ]
    ], function (Router $router) {

        $router->get('', [DashboardController::class, 'index'])->name('dashboard');
        $router->get('logout', [LoginController::class, 'logout'])->name('logout');
        $router->get('details', [DetailController::class, 'show'])->name('view-details');
        $router->put('details', [DetailController::class, 'update'])->name('save-details');
        $router->put('addresses/{address}/set-default', [AddressController::class, 'setDefault'])->name('addresses.set-default');
        $router->resource('addresses', AddressController::class);
    });
});


/** @var Router $router */
$router->group([
    'prefix' => '/admin/',
    'as' => 'admin.',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {

    if (config('members.member_roles')) {
        $router->resource('members/roles', RoleController::class);
    }
    $router->any('members/login-as/{member}', [MemberController::class, 'loginAs'])->name('members.login-as');
    $router->resource('members', MemberController::class);

    $router->group([
        'as' => 'members.',
    ], function (Router $router) {
        $router->put('members/{member}/addresses/{address}/set-default', [MemberAddressController::class, 'setDefault'])->name('addresses.set-default');
        $router->resource('members/{member}/addresses', MemberAddressController::class);
    });

});
