<?php

namespace Mtc\MembersBasket\Factories;

use Mtc\Members\Member;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Class BasketPreFillFactory
 *
 * @package Mtc\MembersBasket\
 */
class BasketPreFillFactory
{
    /**
     * @param Member $member
     * @param $basket
     */
    public function handle(Member $member)
    {
        /** @var BasketRepositoryInterface $basket */
        $basket = App::make(BasketRepositoryInterface::class);
        $basket->setMember($member->id);
        $basket->setDetails([
            'email' => $member->email,
            'contact_number' => $member->contact_no,
        ]);

        if ($member->defaultAddress) {
            $address = $member->defaultAddress
                ->only([
                    'first_name',
                    'last_name',
                    'address1',
                    'address2',
                    'city',
                    'county',
                    'state',
                    'postcode',
                ]);
            $address['country'] = $member->defaultAddress->country_code;

            $basket->setAddress('shipping', $address);
        }

        $member->basket_id = $basket->getId();
        $member->save();
    }
}
