<?php

use Illuminate\Routing\Router;
use Mtc\Members\Http\Middleware\LoggedInMember;
use Mtc\MembersBasket\Http\Controllers\OrderController;
use Mtc\MembersBasket\Http\Controllers\PaymentRegistrationController;

$router->group([
    'prefix' => '/members/',
    'as' => 'members.',
], function (Router $router) {
    $router->post('register-from-payment', [PaymentRegistrationController::class, 'store'])->name('register-from-payment');

    $router->group([
        'middleware' => LoggedInMember::class,
    ], function (Router $router) {
        $router->get('orders', [OrderController::class, 'index'])->name('past-orders');
        $router->get('orders/{order_id}', [OrderController::class, 'show'])->name('view-order');
    });
});
