<?php

use Illuminate\Auth\Events\Login;
use Mtc\Basket\Events\BasketCreated;
use Mtc\Checkout\Events\PaymentSuccessPage;
use Mtc\Members\Events\LoadMembersAreaSections;
use Mtc\MembersBasket\Listeners\AddPastOrdersToMembersArea;
use Mtc\MembersBasket\Listeners\PreFillUsersBasketDetails;
use Mtc\MembersBasket\Listeners\SetUsersBasket;
use Mtc\MembersBasket\Listeners\UnsetUsersBasket;

return [

    'members_basket_events' => [
        PaymentSuccessPage::class => [
            UnsetUsersBasket::class,
        ],
        Login::class => [
            SetUsersBasket::class,
        ],
        BasketCreated::class => [
            PreFillUsersBasketDetails::class
        ],
        LoadMembersAreaSections::class => [
            AddPastOrdersToMembersArea::class,
        ]
    ]
];
