<?php

namespace Mtc\MembersBasket\Http\Controllers;

use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Checkout\Invoice;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\Rules\MediumStrengthPassword;
use Mtc\MembersBasket\Exceptions\MemberAlreadyExists;
use Mtc\MembersBasket\Http\Requests\MembersOrderRequest;
use Mtc\MembersBasket\PaymentRegistrationMemberFactory;

/**
 * Class PaymentRegistrationController
 *
 * @package Mtc\MembersBasket
 */
class PaymentRegistrationController extends Controller
{

    /**
     * View Single order
     *
     * @param MembersOrderRequest $request
     * @return RedirectResponse
     * @throws \Exception
     */
    public function store(Request $request)
    {
        if ($request->hasValidSignature() !== true) {
            return redirect()->to('/');
        }

        $this->validate($request, [
            'password' => [
                'required',
                'confirmed',
                App::make(config('members.password_strength'))
            ]
        ]);

        $invoice = Invoice::query()->find($request->input('id'));
        try {
            $member = App::make(PaymentRegistrationMemberFactory::class)->create($invoice, $request);
            MemberAuth::login($member);
        } catch (MemberAlreadyExists $exception) {
            return redirect()->to(route('members.login'))
                ->withErrors([
                    'email' => __('members_basket::members_basket.account_already_exists'),
                ]);
        }

        return  redirect()->to(route('members.dashboard'));
    }
}
