define([
    'jquery',
    'underscore',
    'ko',
    'Magento_Customer/js/section-config',
    'mage/storage',
    'jquery/jquery-storageapi'
], function ($, _, ko, sectionConfig, mageStorage) {
    'use strict';

    var DataCateg;
    return function (configuration) {

        // console.clear();
        DataCateg = configuration;
        var propagationStop = 0;

        $( document ).ajaxComplete(function( event, xhr, settings ) {
            // var times=0;
            // console.log(times++)
            var userData = {};
            var settingsUrl = settings.url;
            var sectionName = 'mtc_pinterest_pixel_matching_section';
            var urlPath = 'customer/section/load';




            if (propagationStop === 0
                && settingsUrl.indexOf(urlPath) !== -1
                && settingsUrl.indexOf(sectionName) !== -1
            ) {
                propagationStop = 1;
                var response = JSON.parse(xhr.responseText);

                var section;
                var sectionData;


                if (response !== 'undefined' && response.hasOwnProperty('mtc_pinterest_pixel_matching_section')) {

                    section = response.mtc_pinterest_pixel_matching_section;

                    if (section !== 'undefined' && section.hasOwnProperty('matching_data')) {
                        sectionData = section.matching_data;

                        if (!isEmpty(sectionData)) {
                            userData = sectionData;
                        }
                    }
                    if (configuration.baseCodeEnabled) {
                        
                        configuration.pixelCodes.forEach((pixelId) => {
                            if(!isEmpty(userData)) {
                                if (configuration.fpCookieStatus) {
                                    userData.fp_cookie = configuration.fpCookieStatus;
                                }
                                if (configuration.isMdFrequency) {
                                    userData.md_frequency = configuration.isMdFrequency;
                                }
                                window.pintrk('load', pixelId, userData);
                            } else {
                                window.pintrk('load', pixelId);
                            }
                        });

                       

                        productConfig(configuration);
                        if(configuration.isPageEnabled && configuration.isEventEnabled ) {
                            window.pintrk("track", "pagevisit",configuration.productData);
                        }


                        // Add Pixel Events to the button's click handler
                        $('#product-addtocart-button').on('click', function() {
                            // Update product data if detection is enabled
                            if (configuration.isDetectSelectedSkuEnabled) {
                                updateProductData();
                            }
                            // The line_items must have at least one item
                            if (productData.line_items.length) {
                                if(configuration.isAddToCartEnabled)
                                {
                                    pintrk('track', 'addtocart', productData);
                                }

                            }
                        });
                        $('.action.towishlist').on('click', function() {
                            // Update product data if detection is enabled
                            if (configuration.isDetectSelectedSkuEnabled) {
                                updateProductData();
                            }
                            // The line_items must have at least one item
                            if (productData.line_items.length) {
                                if(configuration.isAddToWishListEnabled){pintrk('track', 'addtowishlist', productData);}
                            }
                        });
                        
                        
                    }
                }
            }

        });

        var consentButton = $(configuration.consentButton);
        if (consentButton.length) {
            // Add consent grant call to the consent button's click handler
            consentButton.on('click', function () {
                setTimeout(function () {
                    checkConsent();
                }, 1000);
            });
        }
    }
    function updateProductData() {
       var productData = DataCateg.productData;
       var lineItemsWithIds = DataCateg.lineItemsWithIds;
        var selectedPrice = 0;
        var selectedQty   = 0;
        var productId     = productData.productId;

        var $price        = $('#product-price-' + productId);
        var $priceInclTax = $('#price-including-tax-product-price-' + productId);


        if('line_items' in productData) {
            // Reset line_items
            productData.line_items = [];

            // Set value to 0
            productData.value = 0;

            var qty = 0;
            var newValue = 0;
            var itemValue = 0;
            var itemTotal = 0;
            var globalQty = formatQty($('#qty').val());

            for (let productId in lineItemsWithIds) {
                qty = lineItemsWithIds[productId].product_quantity;
                if (qty > 0) {
                    // Adjust qty with global qty
                    if (globalQty > 1) {
                        qty = qty * globalQty;
                        lineItemsWithIds[productId].product_quantity = qty;
                    }

                    // Set the item in the line_items
                    productData.line_items.push(lineItemsWithIds[productId]);

                    // Increase value based on qty and price
                    itemValue = lineItemsWithIds[productId].product_price;
                    itemTotal = itemValue * qty;
                    // Make sure it is 2 decimal float
                    newValue += parseFloat(parseFloat(itemTotal).toFixed(2));
                }
            }

            // Set value to new value
            productData.value = parseFloat(parseFloat(newValue).toFixed(2));
        }
    }
    function productConfig(configuration){
        var productData = configuration.productEventDataJson;
        var isDetectSelectedSkuEnabled = configuration.isDetectSelectedSkuEnabled;
        var taxFlag = configuration.taxFlag;


        var lineItemsWithIds = configuration.lineItemsWithIds;
        var bundleProductOptionsData = configuration.bundleProductOptionsData;
        var selectors = {};
        
        if(isDetectSelectedSkuEnabled){
            // bof option loop
            for (let optionId in bundleProductOptionsData) {
                // Set all quantity input selectors
                var nameAttributeValue = 'bundle_option_qty[' + optionId + ']';
                selectors['qty' + optionId] = $('input[name="' + nameAttributeValue + '"]');

                // bof Quantity input handler
                selectors['qty' + optionId].on('change keyup paste click', function() {
                    var idAttr        = $(this).attr('id');
                    var oId           = idAttr.replace(/[^0-9]/g, '');
                    var pId           = 0;
                    var typeAttr      = '';
                    var sIds          = 0;
                    var nameAttrValue = '';
                    var valueAttr     = '';

                    // Set qty of all sibling selections
                    var siblings = bundleProductOptionsData[oId];
                    for (let sId in siblings) {
                        pId = siblings[sId]['product_id'];

                        if ($('#bundle-option-' + oId + '-' + sId).length) {
                            // bof radio (checkbox does not have qty input)
                            typeAttr = selectors['opt' + oId + '_' + sId].attr('type');

                            if (typeAttr == 'radio') {
                                if(selectors['opt' + oId + '_' + sId].is(':checked')) {
                                    // Set qty of product to current qty value
                                    lineItemsWithIds[pId].product_quantity = formatQty($(this).val());
                                }
                            }

                            if (typeAttr == 'hidden') {
                                // Case when there is only one radio option
                                // Set qty of product to current qty value
                                lineItemsWithIds[pId].product_quantity = formatQty($(this).val());
                            }
                            // eof radio (checkbox does not have qty input)
                        } else if ($('#bundle-option-' + oId).length) {
                            // bof dropdown (multiselect does not have qty input)
                            sIds = selectors['opt' + oId + '_' + sId].parent().val();

                            if (!Array.isArray(sIds) && sIds == sId) {
                                // Set qty of product to current qty value
                                lineItemsWithIds[pId].product_quantity = formatQty($(this).val());
                            }
                            // eof dropdown (multiselect does not have qty input)
                        } else {
                            // Edge case when there is only one option in dropdown
                            // There is no id only name="bundle_option[X]" value="Y" type="hidden"
                            nameAttrValue = 'bundle_option[' + optionId + ']';
                            selectors['opt' + oId + '_' + sId] = $('input[name="' + nameAttrValue + '"]');

                            typeAttr = selectors['opt' + oId + '_' + sId].attr('type');

                            if (typeAttr == 'hidden') {
                                valueAttr = selectors['opt' + oId + '_' + sId].attr('value');
                                if (valueAttr == sId) {
                                    // Set qty of product to current qty value
                                    lineItemsWithIds[pId].product_quantity = formatQty($(this).val());
                                }
                            }
                        }
                    }
                });
                // eof Quantity input handler

                // bof selection loop
                for (let selectionId in bundleProductOptionsData[optionId]) {
                    // Get product ID
                    var pId = bundleProductOptionsData[optionId][selectionId]['product_id'];

                    // Initialize default product qty var
                    var pQty = 0;

                    // Set qty to 0
                    lineItemsWithIds[pId].product_quantity = 0;

                    if ($('#bundle-option-' + optionId + '-' + selectionId).length) {
                        // bof checkbox and radio

                        var idAttributeValue = 'bundle-option-' + optionId + '-' + selectionId;
                        selectors['opt' + optionId + '_' + selectionId] = $('#' + idAttributeValue);

                        var typeAttr = selectors['opt' + optionId + '_' + selectionId].attr('type');

                        // bof If anything is pre-checked
                        if (selectors['opt' + optionId + '_' + selectionId].is(':checked')) {
                            // Case when there is qty input
                            if (selectors['qty' + optionId].length) {
                                // Set qty of product to current qty value
                                lineItemsWithIds[pId].product_quantity = formatQty(selectors['qty' + optionId].val());
                            } else {
                                // Case when there is no qty input
                                // Get default quantity
                                pQty = bundleProductOptionsData[optionId][selectionId]['product_quantity'];
                                // Set qty of product to defualt quantity
                                lineItemsWithIds[pId].product_quantity = pQty;
                            }
                        }
                        // eof If anything is pre-checked

                        // bof Edge case when there is only one radio
                        if (typeAttr == 'hidden') {
                            // Edge case only one radio option
                            // Case when there is qty input
                            if (selectors['qty' + optionId].length) {
                                // Set qty of product to current qty value
                                lineItemsWithIds[pId].product_quantity = formatQty(selectors['qty' + optionId].val());
                            } else {
                                // Case when there is no qty input
                                // Get default quantity
                                pQty = bundleProductOptionsData[optionId][selectionId]['product_quantity'];
                                // Set qty of product to defualt quantity
                                lineItemsWithIds[pId].product_quantity = pQty;
                            }
                        }
                        // eof Edge case when there is only one radio

                        // bof Edge case when there is 'none' radio option
                        if (typeAttr == 'radio') {
                            if ($('#bundle-option-' + optionId).length) {
                                var oProperty = 'opt' + optionId + '_none';

                                if (!selectors.hasOwnProperty(oProperty)) {
                                    // Set this 'none' radio option only if it is not set
                                    selectors[oProperty] = $('#bundle-option-' + optionId);
                                }

                                // The 'none' radio option handler
                                selectors[oProperty].on('change, click', function() {
                                    var idAttr = $(this).attr('id');
                                    var oId    = idAttr.replace(/[^0-9]/g, '');

                                    if($(this).is(':checked')) {
                                        // Set qty of all siblings to 0
                                        var spId = 0;
                                        var siblings = bundleProductOptionsData[oId];
                                        for (let s in siblings) {
                                            spId = siblings[s]['product_id'];
                                            lineItemsWithIds[spId].product_quantity = 0;
                                        }
                                    }
                                });
                            }
                        }
                        // eof Edge case when there is 'none' radio option

                        // bof checkbox and radio handler
                        selectors['opt' + optionId + '_' + selectionId].on('change, click', function() {

                            var idAttr   = $(this).attr('id');
                            var typeAttr = $(this).attr('type');
                            var oId      = 0;
                            var sId      = 0;
                            var pId      = 0;

                            // Get option IDs from id attribute
                            var optionAndSelectionIds = (idAttr.match(/\d+\.\d+|\d+\b|\d+(?=\w)/g) || []).map(
                                function (v) {return +v;}
                            );

                            // If there are 2 ids then you can detect product ID
                            if (optionAndSelectionIds.length === 2) {
                                oId = optionAndSelectionIds[0];
                                sId = optionAndSelectionIds[1];

                                pId = bundleProductOptionsData[oId][sId]['product_id'];

                                // If it is checkbox
                                if (typeAttr == 'checkbox') {
                                    // If it is checked
                                    if($(this).is(':checked')) {
                                        // Get default quantity
                                        var pQty = bundleProductOptionsData[oId][sId]['product_quantity'];
                                        // Set qty of product to defualt quantity
                                        lineItemsWithIds[pId].product_quantity = pQty;
                                    }
                                    // If it is not checked
                                    if(!$(this).is(':checked')) {
                                        // Set qty of product to 0
                                        lineItemsWithIds[pId].product_quantity = 0;
                                    }
                                }

                                // If it is radio
                                if (typeAttr == 'radio') {
                                    if($(this).is(':checked')) {
                                        // Set qty of all siblings to 0
                                        var spId = 0;
                                        var siblings = bundleProductOptionsData[oId];
                                        for (let s in siblings) {
                                            spId = siblings[s]['product_id'];
                                            lineItemsWithIds[spId].product_quantity = 0;
                                        }

                                        // Set qty of product to current qty value
                                        lineItemsWithIds[pId].product_quantity = formatQty(selectors['qty' + oId].val());

                                        // bof Fix for radio not reading correct qty value
                                        setTimeout(function() {
                                            // Set qty of product to current qty value
                                            lineItemsWithIds[pId].product_quantity = formatQty(selectors['qty' + oId].val());
                                        }, 300);
                                        // eof Fix for radio not reading correct qty value
                                    }
                                }
                            }
                        });
                        // eof checkbox and radio handler

                        // eof checkbox and radio
                    } else if ($('#bundle-option-' + optionId).length) {
                        // bof dropdown and multiselect

                        var idAttribute = 'bundle-option-' + optionId;
                        selectors['opt' + optionId + '_' + selectionId] = $(
                            '#' + idAttribute + ' option[value=' + selectionId +']'
                        );

                        // bof If anything is pre-selected
                        if (selectors['opt' + optionId + '_' + selectionId].is(':selected')) {
                            // Case when there is qty input
                            if (selectors['qty' + optionId].length) {
                                // Set qty of product to current qty value
                                lineItemsWithIds[pId].product_quantity = formatQty(selectors['qty' + optionId].val());
                            } else {
                                // Case when there is no qty input
                                pQty = bundleProductOptionsData[optionId][selectionId]['product_quantity'];
                                // Set qty of product to defualt quantity
                                lineItemsWithIds[pId].product_quantity = pQty;
                            }
                        }
                        // eof If anything is pre-selected

                        // bof dropdown and multiselect handler
                        selectors['opt' + optionId + '_' + selectionId].parent().on(
                            'change, click', function() {

                                var idAttr       = $(this).attr('id');
                                var oId          = idAttr.replace(/[^0-9]/g, '');
                                var sId          = $(this).val();
                                var pId          = 0;
                                var pQty         = 0;
                                var multipleAttr = '';

                                // Set qty of all siblings to 0
                                var siblings = bundleProductOptionsData[oId];
                                var spId     = 0;

                                for (let s in siblings) {
                                    spId = siblings[s]['product_id'];
                                    lineItemsWithIds[spId].product_quantity = 0;
                                }

                                if (Array.isArray(sId)) {
                                    // There is a bug when using for let loop
                                    // sId sometimes gets additional indexes
                                    // Use simple for loop with length and index
                                    // (Happens with multiselect)
                                    for (var i = 0; i < sId.length; i++) {
                                        var selId = sId[i];

                                        // If both exist then set product selection
                                        if (oId && selId) {
                                            // Get product Id
                                            pId = bundleProductOptionsData[oId][selId]['product_id'];
                                            // Get default quantity
                                            pQty = bundleProductOptionsData[oId][selId]['product_quantity'];
                                            // Set qty of product to defualt quantity
                                            lineItemsWithIds[pId].product_quantity = pQty;
                                        } else {
                                            // Edge case if there is 'none' option for multiselect
                                            // Set qty of all siblings to 0
                                            for (let s in siblings) {
                                                spId = siblings[s]['product_id'];
                                                lineItemsWithIds[spId].product_quantity = 0;
                                            }

                                            multipleAttr = $(this).attr('multiple');

                                            if (multipleAttr != 'multiple') {
                                                // Break out of the for loop
                                                // (No need to look at other selections because 'none' is selected.)
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    // If both exist then set product selection
                                    if (oId && sId) {
                                        // Get product Id
                                        pId = bundleProductOptionsData[oId][sId]['product_id'];
                                        // Set qty of product to current qty value
                                        lineItemsWithIds[pId].product_quantity = formatQty(selectors['qty' + oId].val());
                                    } else {
                                        // Edge case if there is 'none' option for dropdown
                                        // Set qty of all siblings to 0
                                        for (let s in siblings) {
                                            spId = siblings[s]['product_id'];
                                            lineItemsWithIds[spId].product_quantity = 0;
                                        }
                                    }
                                }
                            });
                        // eof dropdown and multiselect handler

                        // eof dropdown and multiselect
                    } else {
                        // Edge case when checkbox and multiselect have only one option
                        // Checkbox - There is no id only name="bundle_option[X]" value="Y" type="hidden"
                        // Multiselect - There is no id only name="bundle_option[X]" value="Y" type="hidden"
                        // To unify the code use name attribute selector
                        var nameAttributeValue = 'bundle_option[' + optionId + ']';
                        selectors['opt' + optionId + '_' + selectionId] = $('input[name="' + nameAttributeValue + '"]');

                        var typeAttr = selectors['opt' + optionId + '_' + selectionId].attr('type');

                        if (typeAttr == 'hidden') {
                            var valueAttr = selectors['opt' + optionId + '_' + selectionId].attr('value');
                            if (valueAttr == selectionId) {
                                // Get default quantity
                                pQty = bundleProductOptionsData[optionId][selectionId]['product_quantity'];
                                // Set qty of product to defualt quantity
                                lineItemsWithIds[pId].product_quantity = pQty;
                            }
                        }
                    }
                }
                // eof selection loop
            }
        }
    }
    function isEmpty (obj){
        for (var prop in obj) {
            if (obj.hasOwnProperty(prop)) {
                return false;
            }
        }
        return true;
    }
    function getCookieDataFromString(str) {
        var data = {};

        try {
            data = JSON.parse(str);
        } catch (e) {
            if (str.indexOf('=') > -1) {
                var arr = str.split('=');
                var key = '';
                var value = '';
                var k = 1;

                for (let i = 0; i < arr.length; i += 2) {
                    key = '';
                    value = '';

                    if (arr[i] !== undefined) {
                        key = arr[i].trim();
                    }

                    if (arr[k] !== undefined) {
                        value = arr[k].trim();
                    }

                    if (key) {
                        data[key] = value;
                    }

                    k += 2;
                }
            } else {
                data = str;
            }
        }

        return data;
    }
    function checkConsent() {
        var consentFlag = 0;
        if (isConsentGranted()==="allowed") {
            consentFlag = 1;
        }
        return consentFlag;
    }
    function isConsentGranted() {
        var isCookieConsentEnabled = DataCateg.isCookieConsentEnabled;

        // If cookie consent feature is disabled just allow everything.
        if (!isCookieConsentEnabled) {
            return 1;
        }

        var cookieName = DataCateg.cookieName;
        var cookie = $.mage.cookies.get(cookieName);
        var result = 0;


        if (!cookie) {
            return result;
        }

        var cookieData = getCookieDataFromString(cookie);
        var cookieKey = DataCateg.cookieKey;
        var cookieValue = DataCateg.cookieValue;

        if (cookieKey && cookieValue) {
            if (typeof cookieData === 'object' && cookieData[cookieKey] !== undefined) {
                var value = cookieData[cookieKey];

                if (value == cookieValue) {
                    result = 1;
                }
            }
        } else if (!cookieKey && cookieValue) {
            if (cookie == cookieValue) {
                result = 1;
            }
        } else if (cookieKey && !cookieValue) {
            if (typeof cookieData === 'object' && cookieKey in cookieData) {
                result = 1;
            }
        } else {
            if (cookie) {
                result = 1;
            }
        }

        
        return result;
    }
    // bof Utility functions used by all types of products
    function formatQty(text){
        // Make sure it is 2 decimal float
        return parseFloat(parseFloat(text).toFixed(2));
    }
    function formatPrice(text) {
        var decimalSymbol = escapeRegExp('<?= /* @noEscape */ $block->getPriceDecimalSymbol(); ?>');

        // RegEx to remove everything except numbers and decimal sign
        // Example: /[^0-9\.]/gi
        var regEx = new RegExp('[^0-9' + decimalSymbol + ']', 'gi');
        var priceText = text.replace(regEx, '');

        // Replace decimal sign with decimal point
        var price = priceText.replace(decimalSymbol, '.');

        // Make sure it is 2 decimal float
        return parseFloat(parseFloat(price).toFixed(2));
    }
    function escapeRegExp(text) {
        return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    }

});
