<?php

namespace Mtc\Pinterest\Service;

use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Catalog\Api\Data\CategoryInterfaceFactory;

class CurrentCategory
{
    /**
     * @var \Magento\Catalog\Api\Data\CategoryInterface
     */
    public $category;
    
    /**
     * @var \Magento\Catalog\Api\Data\CategoryInterfaceFactory
     */
    public $categoryFactory;

    /**
     * @var int|string
     */
    public $categoryId;
    
    /**
     * Constructor.
     *
     * @param \Magento\Catalog\Api\Data\CategoryInterfaceFactory $categoryFactory
     */
    public function __construct(
        CategoryInterfaceFactory $categoryFactory
    ) {
        $this->categoryFactory = $categoryFactory;
    }

    /**
     * Sets category interface.
     *
     * @param CategoryInterface $category
     */
    public function set(CategoryInterface $category): void
    {
        $this->category = $category;
    }

    /**
     * Gets category Interface.
     *
     * @return CategoryInterface
     */
    public function get(): CategoryInterface
    {
        return $this->category ?? $this->createNullCategory();
    }
    
    /**
     * Returns empty category interface object.
     *
     * @return CategoryInterface
     */
    public function createNullCategory(): CategoryInterface
    {
        return $this->categoryFactory->create();
    }
    
    /**
     * Returns category.
     *
     * @return \Magento\Catalog\Api\Data\CategoryInterface
     */
    public function getCategory(): CategoryInterface
    {
        return $this->category;
    }
    
    /**
     * Sets category.
     *
     * @param \Magento\Catalog\Api\Data\CategoryInterface $category
     */
    public function setCategory(CategoryInterface $category): void
    {
        $this->category = $category;
    }
    
    /**
     * Returns category id.
     *
     * @return int|string
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    
    /**
     * Sets categroy id.
     *
     * @param int|string $id
     */
    public function setCategoryId($id): void
    {
        $this->categoryId = $id;
    }
}
