<?php

namespace Mtc\Pinterest\Observer;

use Magento\Customer\Api\Data\CustomerInterface;

class CustomerInit implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Mtc\Pinterest\Service\CurrentCustomer
     */
    public $currentCustomer;
    
    /**
     * Constructor.
     *
     * @param \Mtc\Pinterest\Service\CurrentCustomer $currentCustomer
     */
    public function __construct(
        \Mtc\Pinterest\Service\CurrentCustomer $currentCustomer
    ) {
        $this->currentCustomer = $currentCustomer;
    }
    
    /**
     * Execute method.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return \Mtc\Pinterest\Observer\CustomerInit
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $customer        = null;
        $customerId      = 0;
        $customerSession = $observer->getEvent()->getCustomerSession();
        
        if ($customerSession) {
            $customer = $customerSession->getCustomer();
            if ($customer) {
                $customerId = $customer->getId();
                $this->currentCustomer->setCustomerId($customerId);
                $this->currentCustomer->setCustomer($customer);
            }
        }
        
        return $this;
    }
}
