<?php
    declare(strict_types=1);
    namespace Mtc\Pinterest\CustomerData;

    use Magento\Customer\CustomerData\SectionSourceInterface;
    use Magento\Customer\Model\Session;
    use Mtc\Pinterest\Helper\Data;

class MatchingSection implements SectionSourceInterface
{
    /**
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Mtc\Pinterest\Helper\Data      $helper
     */
    public function __construct(
        Session $customerSession,
        Data $helper
    ) {
        $this->customerSession = $customerSession;
        $this->helper = $helper;
    }

    /**
     * @return array|void
     */
    public function getSectionData()
    {
        $customerData = [];
        $customerId = $this->customerSession->getCustomerId();

        if (!$customerId) {
            $customerId = 0;
        }

        $customerData = $this->helper->getUserDataForJs($customerId);

        return [
            'matching_data' => $customerData,
        ];
    }
}
