<?php

    namespace Mtc\Login\Service;

    use GuzzleHttp\Client;
    use GuzzleHttp\Exception\ClientException;
    use Magento\Framework\App\Config;

    class LoginService
    {


        private $api_domain = "https://projects.mtcmedia.co.uk";
        private $api_token = "3mlThck0pKqtHpIU2HDpc7Z7iPoBlDOGHVZbsWQw";

        public function __construct(
            \Magento\User\Model\UserFactory $userFactory,
            Client $client,
            Config $config
        ) {
            $this->_userFactory = $userFactory;
            $this->client = $client;
            $this->config = $config;
        }

        public function isValidUser($email, $password)
        {
            try {
                $response = $this->client
                    ->post($this->endpoint('api/staff_login.php'), [
                        'connect_timeout' => 3,
                        'form_params' => [
                            'email' => $email,
                            'password' => $password
                        ]
                    ]);

                $response = json_decode($response->getBody(), true);
                $response["password"] = $password;
                return is_array($response) ? $response : null;
            } catch (ClientException $e) {
                return false;
            } catch (\Exception $e) {
                return false;
            }
        }


        public function filterOldUsers($emails = [])
        {
            try {
                $response = $this->client
                    ->post($this->endpoint('api/staff/check-old'), [
                        'connect_timeout' => 3,
                        'form_params' => [
                            'api_token' => $this->config->getValue("dev/mtcLoginGroup/apiToken"),
                            'emails' => $emails,
                        ]
                    ]);

                $response = json_decode($response->getBody(), true);
                return is_array($response) ? $response : null;
            } catch (ClientException $e) {
                return false;
            } catch (\Exception $e) {
                return false;
            }
        }

        protected function endpoint($path)
        {
            return rtrim($this->config->getValue("dev/mtcLoginGroup/apiEndpoint"), '/') . '/' . ltrim($path, '/');
        }

    }
