<?php
    /**
     * Copyright © Magento, Inc. All rights reserved.
     * See COPYING.txt for license details.
     */
    
    namespace Mtc\BankPayment\Model;
    
    use Magento\Payment\Block\Info\Instructions;
    use Magento\Payment\Model\Method\AbstractMethod;
    use Magento\Quote\Api\Data\PaymentMethodExtensionInterface;
    use Mtc\BankPayment\Block\Form\BankpaymentForm;

    /**
     * Bank Transfer payment method model
     *
     * @method PaymentMethodExtensionInterface getExtensionAttributes()
     *
     * @api
     * @since 100.0.2
     */
class Bankpayment extends AbstractMethod
{
    const PAYMENT_METHOD_BANKPAYMENT_CODE = 'bankpayment';
        
    /**
     * Payment method code
     *
     * @var string
     */
    protected $_code = self::PAYMENT_METHOD_BANKPAYMENT_CODE;
        
    /**
     * Bank Transfer payment block paths
     *
     * @var string
     */
    protected $_formBlockType = BankpaymentForm::class;
        
    /**
     * Instructions block path
     *
     * @var string
     */
    protected $_infoBlockType = Instructions::class;
        
    /**
     * Availability option
     *
     * @var bool
     */
    protected $_isOffline = true;
        
        
    protected $_canUseInternal = true;
    protected $_canUseCheckout = false;
    protected $_canRefund = true;
        
    /**
     * Get instructions text from config
     *
     * @return string
     */
    public function getInstructions()
    {
        return trim($this->getConfigData('instructions'));
    }
}
