<?php
    /**
     * Copyright © Magento, Inc. All rights reserved.
     * See COPYING.txt for license details.
     */
    
    namespace Mtc\BankPayment\Block\Form;
    
    use Magento\Payment\Block\Form;

    /**
     * Abstract class for Cash On Delivery and Bank Transfer payment method form
     */
abstract class AbstractInstruction extends Form
{
    /**
     * Instructions text
     *
     * @var string
     */
    protected $_instructions;
        
    /**
     * Get instructions text from config
     *
     * @return null|string
     */
    public function getInstructions()
    {
        if ($this->_instructions === null) {
            /**
 * @var \Magento\Payment\Model\Method\AbstractMethod $method
*/
            $method = $this->getMethod();
            $this->_instructions = $method->getConfigData('instructions');
        }
        return $this->_instructions;
    }
}
