<?php
    
    namespace Mtc\Livechat\Block\System\Config;
    
    use Magento\Framework\View\Element\Template;
    use Magento\Framework\View\Element\Template\Context;
    use Mtc\Livechat\Helper\Data;

class LiveChatForm extends Template
{
    /**
     * Path to block template
     */
    const CHECK_TEMPLATE = 'Mtc_Livechat::system/config/livechat_form.phtml';
    
    private $dataHelper;
    
    public function __construct(
        Context $context,
        Data $dataHelper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->dataHelper = $dataHelper;
        $this->urlinterface = $context->getUrlBuilder();
    }
    
    /**
     * @return $this|\Mtc\Livechat\Block\System\Config\LiveChatForm
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if (!$this->getTemplate()) {
            $this->setTemplate(static::CHECK_TEMPLATE);
        }
        return $this;
    }
    
    /**
     * @return string
     */
    public function getLicenseId()
    {
        return $this->dataHelper->getLicenseId();
    }
    
    /**
     * @return string
     */
    public function getLicenseEmail()
    {
        return $this->dataHelper->getLicenseEmail();
    }
    
    /**
     * @return bool
     */
    public function isSetCartProducts()
    {
        return $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_CART_PRODUCTS);
    }
    
    /**
     * @return bool
     */
    public function isSetTotalCartValue()
    {
        return $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_TOTAL_CART_VALUE);
    }
    
    /**
     * @return bool
     */
    public function isSetTotalOrdersCount()
    {
        return $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_TOTAL_ORDERS_COUNT);
    }
    
    /**
     * @return bool
     */
    public function isSetLastOrderDetalils()
    {
        return $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_LAST_ORDER_DETAILS);
    }
}
