<?php
    
    namespace Mtc\Livechat\ViewModel;

    use Magento\Checkout\Model\Session;
    use Magento\Framework\App\Config\ScopeConfigInterface;
    use Magento\Framework\View\Element\Block\ArgumentInterface;
    use Magento\Store\Model\ScopeInterface;
    use Mtc\Livechat\ViewModel\BlockSnippet;
    use Magento\Framework\Url\Helper\Data as UrlHelper;
    
    class CartVM implements ArgumentInterface
    {

        /**
         * @var \Magento\Framework\App\Config\ScopeConfigInterface
         */
        private $scopeConfig;
    
        /**
         * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
         * @param \Magento\Framework\Url\Helper\Data                 $urlHelper
         */
        public function __construct(
            ScopeConfigInterface $scopeConfig,
            UrlHelper $urlHelper,
            Session $checkoutSession
        ) {
            $this->scopeConfig = $scopeConfig;
            $this->urlHelper = $urlHelper;
            $this->_checkoutSession = $checkoutSession;
        }
    
        /**
         * @return string
         */
        public function getLicenseId() :string
        {
            return $this->scopeConfig->getValue(BlockSnippet::LC_LICENSE_ID, ScopeInterface::SCOPE_STORE);
        }
        /**
         * Checks if cart functions are set
         *
         * @return bool
         */
        public function isCartSet()
        {
            if($this->scopeConfig->getValue(BlockSnippet::LC_CP_SHOW_CART_PRODUCTS, ScopeInterface::SCOPE_STORE) ||
                $this->scopeConfig->getValue(BlockSnippet::LC_CP_SHOW_TOTAL_CART_VALUE, ScopeInterface::SCOPE_STORE) ||
                $this->scopeConfig->getValue(BlockSnippet::LC_CP_SHOW_TOTAL_ORDERS_COUNT, ScopeInterface::SCOPE_STORE) ||
                $this->scopeConfig->getValue(BlockSnippet::LC_CP_SHOW_LAST_ORDER_DETAILS, ScopeInterface::SCOPE_STORE)) {
                return true;
            }
        
            return false;
        }
    
        public function isOrderPlacedPage() {
            $check = 0;
            if($this->_checkoutSession->getLastRealOrder()->getId()){
               $check = 1;
            }
            return $check;
        }
    
    }
