<?php
    declare(strict_types=1);
    
    namespace Mtc\Livechat\Helper;

    use Magento\Framework\App\Helper\AbstractHelper;
    use \Magento\Framework\App\Helper\Context;
    use Magento\Store\Model\ScopeInterface;

    class Data extends AbstractHelper
    {
        const LAST_ORDER_DETAILS_PATTERN =
            'Created at: %createdAt%, updated at: %updatedAt%, status: %status%, state: %state%, grand total: %grandTotal% %currency%';
        const PRODUCT_DETAILS_PATTERN = '%name% (%qty%) %price% %currency%; ';
        const LC_LICENSE_ID = 'lc_block_config/account/license_id';
        const LC_LICENSE_EMAIL = 'lc_block_config/account/license_email';
        const LC_CP_SHOW_CART_PRODUCTS = 'lc_block_config/custom_params/cart_products';
        const LC_CP_SHOW_TOTAL_CART_VALUE = 'lc_block_config/custom_params/total_cart_value';
        const LC_CP_SHOW_TOTAL_ORDERS_COUNT = 'lc_block_config/custom_params/total_orders_count';
        const LC_CP_SHOW_LAST_ORDER_DETAILS = 'lc_block_config/custom_params/last_order_details';
    
    
        /**
         * @param \Magento\Framework\App\Helper\Context $context
         */
        public function __construct(
            Context $context
        ) {
            parent::__construct($context);
        }
    
        /**
         * @return string
         */
        public function getLicenseId() :string
        {
            return $this->scopeConfig->getValue(self::LC_LICENSE_ID, ScopeInterface::SCOPE_STORE);
        }
    
        /**
         * @return string
         */
        public function getLicenseEmail() :string
        {
            return $this->scopeConfig->getValue(self::LC_LICENSE_EMAIL, ScopeInterface::SCOPE_STORE);
        }
    
        /**
         * @param $key
         *
         * @return bool
         */
        public function showCustomParam($key) :bool
        {
            return (boolean) $this->scopeConfig->getValue($key, ScopeInterface::SCOPE_STORE);
        }
        
    
    }
